; Copyright (c) 1998-2007 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		LN_LOCAT.PRO
;
;LAST CHANGED: ----------------------------------- 	07-Jan-07
;
; PURPOSE:
;	This procedure reads co-rodinates of a linescan and places them on the image currently
; displayed. If the current buffer is not an image or does not contain the
; location of the line, the user is prompted to read an image.
; Default linescan format is SDF (ALS/CLS/SLS); optional for old STXM701; need to develop for NSLS
;
; CATEGORY:
;	Image display in aXis2000  Linescans~locate line
;
; CALLING SEQUENCE:
; for procedures:
;	LN_LOCAT [, STXM701=STXM701 ]
;
; INPUTS:
;	All input parameters are passed as keywords or acquired by prompts.
;
; KEYWORDS:
;	STXM701	original code for pre2000 files from ALS STXM7.0.1
;
; OUTPUTS:
;	No explicit outputs.
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; SIDE EFFECTS: none
;
; RESTRICTIONS:
;
; KNOWN ERRORS:
; If start from an empty buffer there are errors as AXIS tries to replot an empty buffer
;
; MODIFICATION HISTORY:
; (01-jan-99 aph) segregated from aaa-axis
; (10-feb-99 aph) fixed code error !
; (07-Jan-07 aph) AXIS standard header added; adapted to SDF files
;-

PRO ln_locat, stxm701=stxm701
@axis_com

IF keyword_Set(stxm701) then begin
  HANDLE_VALUE, Data(CurBuf), tmp     ;Get the data
  IF n_tags(tmp) EQ 0 THEN RETURN
  IF tmp.t EQ '2d' THEN BEGIN
		LineClear                  ; remove any lines on image from linout
	    file = PICKFILE2(/Read,filter='*.dat',/lpath, DefPath=DefPath)
	    openr, lun, file, /get_lun
	   	x1 = float(0)  &  y1 = float(0)
		xstep = float(0)
		npts = fix(0)
		ystep = float(0)
		input_string = ''
	   	readf, lun, input_string
	   	readf, lun, input_string
; -------------- from Rick Steele (4-May-98) -------------------
; The coordinates on line 2 are given in mm. The numbers on line two are:
;(1)  starting X position
;(2)  X step size
;(3)  starting Y position
;(4)  Y step size
;(5)  number of points measured along line
;So in the example you show, the starting position of the line is, in
;microns, (-5.8104, -3.4569) and the endpoint of the line is
;(-5.8104+200*.045021,-3.4569+200*.020232) = (3.1938, 0.5895).
; ----------------------------------------------------------------
	  	reads,input_string, x1, xstep, y1, ystep, npts
	   	x1 = 1.e3*x1   & y1 = 1.e3*y1	; AXIS expresses distances in microns
	   	x2 = x1 + (npts-1)*1.e3*xstep
	   	y2 = y1 + (npts-1)*1.e3*ystep
	   	print, format='("Linescan: ",i3," pts. (",f6.2,", ",f6.2,") to (",f6.2,", ",f6.2,")")', $
	   	    npts, x1, y1, x2, y2
	   close, lun
;	   if x1 GT x2 then begin
;	   		xt = x1 & x1=x2 & x2 = xt   ; ensure low-high order
;	   endif
;	   if y1 GT y2 then begin
;	   		yt = y1 & y1=y2 & y2 = yt
;	   endif
;	   if x1 GT max(tmp.x) OR x2 LT min(tmp.x) $
;	      OR y1 GT max(tmp.y) OR y2 LT min(tmp.y) then begin
;	   	  WIDGET_CONTROL, Uprompt, SET_VALUE='Linescans.locate line: line not on scale'
;	      goto, locate_line_continue
;	   endif
;	   if x1 LT tmp.x(0) then x1 = tmp.x(0)         ; plot part on current display
;	   if x2 GT max(tmp.x) then x2 = max(tmp.x)
;	   if y1 LT tmp.y(0) then y1 = tmp.y(0)
;	   if y2 GT max(tmp.y) then y2 = max(tmp.y)
;	   	print, format='("plotted Linescan: ",i3," pts. (",f6.2,", ",f6.2,") to (",f6.2,", ",f6.2,")")', $
;	   	    npts, x1, y1, x2, y2

		plots, x1, y1,/data
	  	plots, [x1,x2], [y1,y2],/data, thick=2,/continue, color=255
		LineClear
	ENDIF
ENDIF ELSE BEGIN
; ------------------------------------------------------------------
; CODE for SDF files
; ------------------------------------------------------------------
; read in linescan file to obtain co-ordinates
	tmp = read_sdf(/header_only, /silent)
	if n_tags(tmp) EQ 0 then return
; check that file is actually a linescan
	if tmp.type NE 'NEXAFS Line Scan' then begin
		axis_log, 'Scan type is ' + tmp.type + '.  Not a linescan'
		return
	endif
; extract line parameters
	centrexpos = tmp.imagescan.spatialregions.centrexpos
	centreypos = tmp.imagescan.spatialregions.centreypos
	length     = tmp.imagescan.spatialregions.length
	theta      = 3.1416*tmp.imagescan.spatialregions.theta/180.  ; convert to radians
	npts = tmp.imagescan.spatialregions.points
   	x1 = centrexpos - 0.5*length*cos(theta)
   	x2 = centrexpos + 0.5*length*cos(theta)
   	y1 = centreypos - 0.5*length*sin(theta)
   	y2 = centreypos + 0.5*length*sin(theta)
   	text = string(npts, x1, y1, x2, y2, $
   	  format='("Linescan line: ",i3," pts. (",f7.2,", ",f7.2,") to (",f7.2,", ",f7.2,")")')
   	axis_log, text

; check if current buffer contains an image - if not read an image
    HANDLE_VALUE, Data(CurBuf), tmp
    IF n_tags(tmp) NE 0 then begin
    	if tmp.t EQ '2d' then goto, line_locate_cont
    ENDIF ELSE BEGIN
    	tmp = ax_sdf()
    	if  n_tags(tmp) EQ 0 THEN RETURN
    	HANDLE_value, Data(CurBuf),tmp,/set
    	Plotbuf,CurBuf
    ENDELSE

; check if line fits on image
line_locate_cont:
    IF x1 LT tmp.x(0) OR x2 GT tmp.x(n_elements(tmp.x)-1) OR $
       y1 LT tmp.y(0) OR y2 GT tmp.y(n_elements(tmp.y)-1) then begin
        axis_log, 'Linescans.locate line: line not on scale'
        tmp = ax_sdf()
        if  n_tags(tmp) EQ 0 THEN RETURN
    ENDIF
; plot line on the image
	SetGraf, 'MainImg'
	LineClear
	plots, x1, y1,/data
  	plots, [x1,x2], [y1,y2],/data, thick=2,/continue, color=255
ENDELSE
RETURN
END
