; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		SAV_HDF
;
;LAST CHANGED: ----------------------------------- 	21-Feb-10
;
; PURPOSE:
;	This procedure writes an aXis2000 structure (1d,2d, 3d or 4d)
;  to an HDF scientific format file.
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
; for procedures:
;	SAV_HDF, tmp, fltr=fltr, file=file
;
; INPUTS:
;	TMP		aXis2000 data structure
;
; KEYWORDS:
;	FLTR -  name of  extension to filter file name choice
;   FILE -  filename
;
; OUTPUTS:
;	SDF file saved
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; MODIFICATION HISTORY:
; (18-jun-98 aph) adapted from MakeHFDdata in idl40\examples\hdf_netcdf\hdf_rdwr.pro
; (21-Feb-10 aph) AXIS standard header added; name changed to satisfy batch compile
;-

PRO sav_HDF, tmp, fltr=fltr, file=file

on_error,2
@axis_com
IF n_tags(tmp) NE 0 then BEGIN
  if tmp.t EQ '2d' then BEGIN
	IF NOT keyword_set(file) then BEGIN
	     if not keyword_set(fltr) then fltr='*.hdf'
   		 file=PICKFILE2(/Write, FILTER=fltr, /LPATH, DEFPATH=defpath)
    endif

;	Create (or overwrite) a Scientific Data Set (SDS)
	HDF_DFSD_SETINFO,	$
		/CLEAR,		$		; Reset SDS internal vars.
		/FLOAT,		$		; Data is floating point
		DIMS=[n_elements(tmp.x),n_elements(tmp.y)],	$
		LABEL=tmp.dl, $		; TITLE=...
		UNIT="um"			; UNITS=...
	HDF_DFSD_DIMSET, 0, LABEL=tmp.xl
	HDF_DFSD_DIMSET, 1, LABEL=tmp.yl
	;	Create and write the data
	HDF_DFSD_ADDDATA, file, tmp.d, /OVERWRITE
   endif
ENDIF
END
